function xprime=statetrackingm_derivatives(t,x)

global k1 k icon rho w  xs xsr tstart grad dt CovnT DeltaT ts tsr lambda;
global usave tsave 

x1=x(1);
x2=x(2);

z1=x1;
z2=-x1+x2;

dt=t-tstart;

if t==0  
   error=0; dt=CovnT; %dt=DeltaT;
else
   error=norm(x-xs);
end

% the threshold is determined from the robust analysis
if icon==1
   thresh=norm(grad)/20000
else
   thresh=norm(grad)/20
end

if (dt>=CovnT & error <=thresh)  
    
if icon==1       
   % Banana Function
   [f,grad]=banana(x);  
    alpha1=0.0012;
elseif icon==0  
   % another cost function   
   grad=[10*x1+4*x2-14;2*x2+4*x1-6];
   alpha1=0.15;
else
   grad=[2*(x1-2);2*(x2-3)];
   alpha1=0.3;
end
    
% obtained step length
alpha2=alpha1;
xs=[x1-alpha1*grad(1);x2-alpha2*grad(2)];   % ideal search destination
xsr(:,end+1)=xs;
tsr(:,end+1)=t;
tstart=t;
end

% generate the desired set point
zs(1)=xs(1);
zs(2)=-xs(1)+xs(2);

% generate a periodic refernce trajectory
a2=zs(1);
w1=2*pi/ts;
a1=zs(2)/w1;

zs1=a1*sin(w1*t)+a2;
zs2=a1*w1*cos(w1*t);
zs3=-a1*w1*w1*sin(w1*t);

% constrained control, determine k1
mu0=exp(-0.5*t)*norm([z1-zs1,z2-zs2])
k1=min(((2.1-norm([zs1,zs2]))/mu0),3)

% error systems
e=k1*(z1-zs1)+(z2-zs2);
xi=k1*(z2-zs2)-zs3;

u=-xi+(-x1+x2)-x1*x2-k*e;

% Plant dynamics
xprime(1)=-x1+x2;
xprime(2)=x1*x2+u;
% with bounded input disturbance 
%xprime(2)=x1*x2+(u+2*rand(1)); 
% with unbounded input disturbance
%xprime(2) = x1*x2+(u+1/(abs(x1)+1*rand(1))+3*(cos(t)+1)*(x2));

xprime=xprime.';


tsave = [tsave;t];
usave = [usave;u];